/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.RelativePosition;
import com.roguewave.chart.core.v2_1.graphics.StandardColors;
import com.roguewave.chart.standard.v2_1.parts.SingleColumnLegendDrawable;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;

public class SingleColumnLegend
implements Customizer {
    private final Font defaultLegendItemFont = new Font("TimesRoman", 1, 14);
    private final double defaultLegendItemBoxSize = 14.0;
    String[] legendItems_;
    Color[] colors_;

    public SingleColumnLegend() {
        this.legendItems_ = null;
        this.colors_ = null;
    }

    public SingleColumnLegend(String[] stringArray, Color[] colorArray) {
        this.legendItems_ = stringArray;
        this.colors_ = colorArray;
    }

    public Drawable getDrawable(ChartProperties chartProperties, DataModel dataModel) {
        Font font = (Font)chartProperties.getProperty("LegendItemFont", this.defaultLegendItemFont);
        if (this.legendItems_ == null) {
            StandardColors standardColors = new StandardColors();
            this.legendItems_ = new String[dataModel.getRowCount()];
            this.colors_ = new Color[this.legendItems_.length];
            int n = 0;
            while (n < this.legendItems_.length) {
                this.legendItems_[n] = dataModel.getRowLabel(n);
                this.colors_[n] = chartProperties.getColor(n, 0, standardColors.color(n), 0.0);
                ++n;
            }
        }
        int n = (int)(chartProperties.getProperty("LegendItemBoxSize", 14.0) + 0.5);
        Color color = (Color)chartProperties.getProperty("LegendTextColor", Color.black);
        Color color2 = (Color)chartProperties.getProperty("LegendBackgroundColor", Color.lightGray);
        RelativePosition relativePosition = new RelativePosition(0.5, 1.0, 0, -20, 3);
        relativePosition = (RelativePosition)chartProperties.getProperty("LegendPosition", relativePosition);
        return new SingleColumnLegendDrawable(this.legendItems_, this.colors_, relativePosition, font, n, color, color2);
    }

    public Customizer getLegend() {
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }
}

